<?php
session_start();
$error = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    include '../api/config.php';
    $u = $_POST['username'];
    $p = $_POST['password'];
    $stmt = $conn->prepare("SELECT password FROM admin WHERE username=?");
    $stmt->bind_param('s', $u);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res->num_rows > 0) {
        $row = $res->fetch_assoc();
        // Gunakan password_verify() jika Anda sudah mengimplementasikan hashing.
        // Untuk saat ini, kita tetap menggunakan perbandingan langsung sesuai struktur awal.
        if ($p === $row['password']) { // Ganti dengan password_verify($p, $row['password']) untuk keamanan
            $_SESSION['admin'] = $u;
            header('Location: dashboard.php');
            exit;
        }
    }
    $error = 'Username atau password salah.';
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login | LowFeeCoffee</title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

    <style>
        :root {
            --primary-color: #583e2b; /* Coklat Tua */
        }
        body {
            background-color: #fdfaf6; /* Warna krem yang sama dengan halaman menu */
            font-family: 'Poppins', sans-serif;
        }
        .login-card {
            width: 100%;
            max-width: 420px;
            padding: 2.5rem;
            border: none;
            border-radius: 1rem;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        }
        .login-card .logo {
            width: 80px;
            height: auto;
            margin: 0 auto 1rem;
            display: block;
        }
        .login-card h3 {
            font-weight: 600;
        }
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(88, 62, 43, 0.25);
        }
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 10px;
            font-weight: 500;
        }
        .btn-primary:hover {
            background-color: #4a3424;
            border-color: #4a3424;
        }
        .input-group-text {
            background-color: #e9ecef;
            border: 1px solid #ced4da;
        }
    </style>
</head>
<body class="d-flex align-items-center justify-content-center vh-100">

    <div class="card login-card">
        <div class="card-body">
            <img src="../assets/uploads/logolow.jpg" alt="Logo" class="logo">
            <h3 class="card-title text-center mb-2">Admin Login</h3>
            <p class="card-text text-center text-muted mb-4">Silakan masuk untuk mengelola sistem.</p>

            <form method="post">
                <?php if($error): ?>
                    <div class="alert alert-danger" role="alert">
                        <i class="bi bi-exclamation-triangle-fill me-2"></i> <?= $error ?>
                    </div>
                <?php endif; ?>

                <div class="mb-3">
                    <label for="username" class="form-label">Username</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-person-fill"></i></span>
                        <input type="text" name="username" id="username" class="form-control" placeholder="Masukkan username" required autofocus>
                    </div>
                </div>

                <div class="mb-4">
                    <label for="password" class="form-label">Password</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="bi bi-lock-fill"></i></span>
                        <input type="password" name="password" id="password" class="form-control" placeholder="Masukkan password" required>
                    </div>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-box-arrow-in-right me-2"></i>Login
                    </button>
                </div>
            </form>
        </div>
    </div>

</body>
</html>