<?php
session_start();
if (!isset($_SESSION['admin'])) header('Location: login.php');
include '../api/config.php';
$categories = ['Based Coffee', 'Non-coffee', 'Signature', 'Snack'];

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_menu'])) {
    $name = $_POST['name'];
    $description = $_POST['description'];
    $category = $_POST['category'];
    $price = $_POST['price'];
    $avaiable = $_POST['avaiable'];
    $img = '';
    if ($_FILES['image']['name']) {
        $target_dir = "../assets/uploads/";
        $img = uniqid() . basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'], $target_dir . $img);
    }

    $stmt = $conn->prepare("INSERT INTO menu (name, description, category, price, image, avaiable) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param('sssisi', $name, $description, $category, $price, $img, $avaiable);
    $stmt->execute();
    header('Location: menu-management.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_menu'])) {
    $id = $_POST['id'];
    $stmt = $conn->prepare("SELECT image FROM menu WHERE id=?");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res->num_rows > 0) {
        $img_to_delete = $res->fetch_assoc()['image'];
        if ($img_to_delete && file_exists('../assets/uploads/' . $img_to_delete)) {
            unlink('../assets/uploads/' . $img_to_delete);
        }
    }

    $stmt = $conn->prepare("DELETE FROM menu WHERE id=?");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    header('Location: menu-management.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Manajemen Menu | Admin LowFeeCoffee</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <style>
        body {
            background-color: #f8f1e4;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #4e342e;
        }

        .main-header {
            background-color: #8d6e63;
            color: white;
        }

        .text-coffee {
            color: #fff;
        }

        .btn-primary {
            background-color: #8d6e63;
            border-color: #8d6e63;
        }

        .btn-primary:hover {
            background-color: #6d4c41;
            border-color: #6d4c41;
        }

        .btn-secondary {
            background-color: #a1887f;
            border-color: #a1887f;
        }

        .btn-secondary:hover {
            background-color: #8d6e63;
            border-color: #8d6e63;
        }

        .btn-edit {
            background-color: #a1887f;
            border-color: #a1887f;
            color: #fff;
        }

        .btn-edit:hover {
            background-color: #8d6e63;
            border-color: #8d6e63;
            color: #fff;
        }

        .btn-delete {
            background-color: #6d4c41;
            border-color: #6d4c41;
            color: #fff;
        }

        .btn-delete:hover {
            background-color: #5d4037;
            border-color: #5d4037;
            color: #fff;
        }

        .card {
            border-radius: 12px;
            background-color: #fffaf5;
        }

        .modal-content {
            border-radius: 12px;
        }

        label {
            color: #4e342e;
            font-weight: 500;
        }

        .form-control, .form-select {
            border-radius: 8px;
        }

        input[type="file"]::file-selector-button {
            background-color: #8d6e63;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 6px;
        }

        input[type="file"]::file-selector-button:hover {
            background-color: #6d4c41;
        }

        .table {
            border-collapse: separate;
            border-spacing: 0 0.5rem;
            color: #4e342e;
        }

        .table thead {
            background-color: #bcaaa4;
            color: #3e2723;
            font-weight: 600;
        }

        .table thead th {
            border: none;
            padding: 12px;
            font-size: 0.95rem;
        }

        .table tbody tr {
            background-color: #fffaf5;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            transition: background-color 0.2s ease;
        }

        .table tbody tr:hover {
            background-color: #f3e5f5;
        }

        .table tbody td {
            padding: 14px;
            vertical-align: middle;
            border-top: 1px solid #e0cfc2;
            font-size: 0.95rem;
        }

        .table img {
            border-radius: 8px;
            border: 1px solid #ccc;
            max-width: 80px;
            height: auto;
            box-shadow: 0 1px 4px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
<header class="main-header shadow-sm py-3 mb-4">
    <div class="container d-flex justify-content-between align-items-center">
        <h1 class="fs-4 m-0 fw-bold text-coffee">Manajemen Menu</h1>
        <a href="logout.php" class="btn btn-sm btn-outline-light"><i class="bi bi-box-arrow-right"></i> Logout</a>
    </div>
</header>

<div class="container">
    <div class="d-flex justify-content-start align-items-center gap-2 mb-3">
        <a href="dashboard.php" class="btn btn-secondary"><i class="bi bi-arrow-left"></i> Kembali ke Dashboard</a>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addMenuModal"><i class="bi bi-plus-circle"></i> Tambah Menu Baru</button>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th>Gambar</th>
                            <th>Nama Menu</th>
                            <th>Deskripsi</th>
                            <th>Kategori</th>
                            <th>Harga</th>
                            <th>Ketersediaan</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $result = $conn->query("SELECT * FROM menu ORDER BY category, name");
                        while ($row = $result->fetch_assoc()):
                        ?>
                        <tr>
                            <td><img src="../assets/uploads/<?= htmlspecialchars($row['image']) ?>" alt="" width="80"></td>
                            <td><?= htmlspecialchars($row['name']) ?></td>
                            <td style="max-width: 300px;"><?= htmlspecialchars($row['description']) ?></td>
                            <td><?= htmlspecialchars($row['category']) ?></td>
                            <td>Rp <?= number_format($row['price'], 0, ',', '.') ?></td>
                            <td><?= $row['avaiable'] ? 'Tersedia' : 'Tidak Tersedia' ?></td>
                            <td>
                                <button class="btn btn-sm btn-edit" data-bs-toggle="modal" data-bs-target="#editMenuModal" 
                                    data-id="<?= $row['id'] ?>" 
                                    data-name="<?= htmlspecialchars($row['name']) ?>"
                                    data-description="<?= htmlspecialchars($row['description']) ?>"
                                    data-category="<?= $row['category'] ?>"
                                    data-price="<?= $row['price'] ?>">
                                    <i class="bi bi-pencil-square"></i> Edit
                                </button>
                                <form method="post" class="d-inline" onsubmit="return confirm('Apakah Anda yakin ingin menghapus menu ini?');">
                                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                    <button type="submit" name="delete_menu" class="btn btn-sm btn-delete"><i class="bi bi-trash-fill"></i> Hapus</button>
                                </form>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal Tambah Menu -->
<div class="modal fade" id="addMenuModal" tabindex="-1" aria-labelledby="addMenuModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addMenuModalLabel">Tambah Menu Baru</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="post" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label class="form-label">Nama Menu</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Deskripsi Menu</label>
                        <textarea name="description" class="form-control" rows="3"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kategori</label>
                        <select name="category" class="form-select" required>
                            <?php foreach ($categories as $cat): ?>
                                <option value="<?= $cat ?>"><?= $cat ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Harga</label>
                        <input type="number" name="price" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Gambar</label>
                        <input type="file" name="image" class="form-control" accept="image/*">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tersedia?</label>
                        <select name="avaiable" class="form-select" required>
                            <option value="1">Tersedia</option>
                            <option value="0">Tidak Tersedia</option>
                        </select>
                    </div>
                    <button type="submit" name="add_menu" class="btn btn-primary">Simpan</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal Edit Menu -->
<div class="modal fade" id="editMenuModal" tabindex="-1" aria-labelledby="editMenuModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editMenuModalLabel">Edit Menu</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editMenuForm" enctype="multipart/form-data">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="mb-3">
                        <label class="form-label">Nama Menu</label>
                        <input type="text" name="name" id="edit_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Deskripsi Menu</label>
                        <textarea name="description" id="edit_description" class="form-control" rows="3"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kategori</label>
                        <select name="category" id="edit_category" class="form-select" required>
                            <?php foreach ($categories as $cat): ?>
                                <option value="<?= $cat ?>"><?= $cat ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Harga</label>
                        <input type="number" name="price" id="edit_price" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tersedia</label>
                        <select name="avaiable" class="form-select" required>
                            <option value="1">Tersedia</option>
                            <option value="0">Tidak Tersedia</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Gambar Baru (Opsional)</label>
                        <input type="file" name="image" class="form-control" accept="image/*">
                    </div>
                    <button type="submit" class="btn btn-primary">Update</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
const editMenuModal = document.getElementById('editMenuModal');
editMenuModal.addEventListener('show.bs.modal', function (event) {
    const button = event.relatedTarget;
    document.getElementById('edit_id').value = button.dataset.id;
    document.getElementById('edit_name').value = button.dataset.name;
    document.getElementById('edit_description').value = button.dataset.description;
    document.getElementById('edit_category').value = button.dataset.category;
    document.getElementById('edit_price').value = button.dataset.price;
});

document.getElementById('editMenuForm').addEventListener('submit', function (e) {
    e.preventDefault();
    const formData = new FormData(this);
    fetch('../api/edit-menu.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if(data.success) {
            alert('Menu berhasil diupdate!');
            location.reload();
        } else {
            alert('Gagal mengupdate menu: ' + (data.message || 'Error tidak diketahui'));
        }
    })
    .catch(err => {
        alert('Terjadi kesalahan jaringan.');
    });
});
</script>
</body>
</html>
