<?php
session_start();
if (!isset($_SESSION['admin'])) header('Location: login.php');
include '../api/config.php';

$orders = $conn->query("SELECT * FROM orders ORDER BY order_time DESC");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Kelola Pesanan | Admin LowFeeCoffee</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <style>
        body {
            background-color: #f8f1e4;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #4e342e;
        }
        .main-header {
            background-color: #8d6e63;
            color: white;
        }
        .text-coffee {
            color: #fff;
        }
        .btn-primary {
            background-color: #8d6e63;
            border-color: #8d6e63;
            color: white;
        }
        .btn-primary:hover {
            background-color: #6d4c41;
            border-color: #6d4c41;
        }
        .btn-secondary {
            background-color: #a1887f;
            border-color: #a1887f;
            color: white;
        }
        .btn-secondary:hover {
            background-color: #8d6e63;
            border-color: #8d6e63;
        }
        .card {
            border-radius: 12px;
            background-color: #fffaf5;
        }
        .modal-content {
            border-radius: 12px;
        }
        label {
            color: #4e342e;
            font-weight: 500;
        }
        .form-control,
        .form-select {
            border-radius: 8px;
        }
        input[type="file"]::file-selector-button {
            background-color: #8d6e63;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 6px;
        }
        input[type="file"]::file-selector-button:hover {
            background-color: #6d4c41;
        }
        .table {
            border-collapse: separate;
            border-spacing: 0 0.5rem;
            color: #4e342e;
        }
        .table thead {
            background-color: #bcaaa4;
            color: #3e2723;
            font-weight: 600;
        }
        .table thead th {
            border: none;
            padding: 12px;
            font-size: 0.95rem;
        }
        .table tbody tr {
            background-color: #fffaf5;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
            transition: background-color 0.2s ease;
        }
        .table tbody tr:hover {
            background-color: #f3e5f5;
        }
        .table tbody td {
            padding: 14px;
            vertical-align: middle;
            border-top: 1px solid #e0cfc2;
            font-size: 0.95rem;
        }
        .table img {
            border-radius: 8px;
            border: 1px solid #ccc;
            max-width: 80px;
            height: auto;
            box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1);
        }
        .badge {
            font-size: 0.9rem;
            padding: 5px 10px;
            border-radius: 8px;
            font-weight: 500;
            display: inline-block;
        }
        .badge-pending {
            background-color: #ffe082;
            color: #5d4037;
        }
        .badge-processing {
            background-color: #90caf9;
            color: #0d47a1;
        }
        .badge-done {
            background-color: #a5d6a7;
            color: #2e7d32;
        }
        .badge-cancelled {
            background-color: #ef9a9a;
            color: #b71c1c;
        }
        .aksi-buttons {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }
        .aksi-buttons form {
            display: flex;
            gap: 0.5rem;
            align-items: center;
        }
        .form-select-sm {
            min-width: 120px;
        }
    </style>
</head>
<body>

<header class="main-header shadow-sm py-3 mb-4">
    <div class="container d-flex justify-content-between align-items-center">
        <h1 class="fs-4 m-0 fw-bold text-coffee">Kelola Pesanan</h1>
        <a href="logout.php" class="btn btn-sm btn-outline-light"><i class="bi bi-box-arrow-right"></i> Logout</a>
    </div>
</header>

<div class="container mb-5">
    <a href="dashboard.php" class="btn btn-secondary mb-3"><i class="bi bi-arrow-left"></i> Kembali ke Dashboard</a>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Meja</th>
                            <th>Nama</th>
                            <th>No hp</th>
                            <th>Status</th>
                            <th>Waktu</th>
                            <th>Detail</th>
                            <th>Catatan</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $orders->fetch_assoc()): ?>
                        <tr id="order-row-<?= $row['id'] ?>">
                            <td><?= $row['id'] ?></td>
                            <td><?= htmlspecialchars($row['table_number']) ?></td>
                            <td><?= htmlspecialchars($row['customer_name']) ?></td>
                            <td><?= htmlspecialchars($row['customer_phone']) ?></td>
                            <td>
                                <?php
                                    $status = $row['status'];
                                    if ($status === 'pending') {
                                        $badgeClass = 'badge-pending';
                                    } elseif ($status === 'processing') {
                                        $badgeClass = 'badge-processing';
                                    } elseif ($status === 'done') {
                                        $badgeClass = 'badge-done';
                                    } elseif ($status === 'cancelled') {
                                        $badgeClass = 'badge-cancelled';
                                    } else {
                                        $badgeClass = 'bg-secondary text-white';
                                    }
                                ?>
                                <span class="badge <?= $badgeClass ?> status-badge-<?= $row['id'] ?>"><?= $status ?></span>
                            </td>
                            <td><?= $row['order_time'] ?></td>
                            <td>
                                <?php
                                $items = $conn->query("SELECT m.name, oi.quantity FROM order_items oi JOIN menu m ON oi.menu_id=m.id WHERE oi.order_id=" . $row['id']);
                                while ($item = $items->fetch_assoc()) {
                                    echo htmlspecialchars($item['name']) . ' x' . $item['quantity'] . '<br>';
                                }
                                ?>
                            </td>
                            <td><?= nl2br(htmlspecialchars($row['note'])) ?></td>
                            <td>
                                <div class="aksi-buttons">
                                    <?php if ($row['status'] != 'processing'): ?>
                                    <form class="update-status-form" data-order-id="<?= $row['id'] ?>">
                                        <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                        <select name="status" class="form-select form-select-sm">
                                            <option value="pending" <?= $row['status'] == 'pending' ? 'selected' : '' ?>>pending</option>
                                            <option value="done" <?= $row['status'] == 'done' ? 'selected' : '' ?>>done</option>
                                            <option value="cancelled" <?= $row['status'] == 'cancelled' ? 'selected' : '' ?>>cancelled</option>
                                        </select>
                                        <button type="submit" class="btn btn-primary btn-sm">Update</button>
                                    </form>
                                    <?php else: ?>
                                        <div class="text-muted small">Sedang diproses</div>
                                    <?php endif; ?>
                                    <a href="print-receipt.php?id=<?= $row['id'] ?>" target="_blank" class="btn btn-secondary btn-sm mt-1">Cetak Struk</a>
                                </div>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
document.querySelectorAll('.update-status-form').forEach(form => {
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        const formData = new FormData(form);
        const orderId = form.dataset.orderId;
        const button = form.querySelector('button[type="submit"]');
        const originalButtonText = button.innerHTML;

        button.innerHTML = 'Menyimpan...';
        button.disabled = true;

        fetch('../api/update-order-status.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(res => {
            if(res.success) {
                alert('Status pesanan berhasil diperbarui!');
                const statusBadge = document.querySelector(`.status-badge-${orderId}`);
                if(statusBadge) {
                    const newStatus = formData.get('status');
                    statusBadge.textContent = newStatus;
                    const statusClasses = {
                        pending: 'badge-pending',
                        processing: 'badge-processing',
                        done: 'badge-done',
                        cancelled: 'badge-cancelled'
                    };
                    statusBadge.className = 'badge status-badge-' + orderId + ' ' + (statusClasses[newStatus] || 'bg-secondary');
                }
            } else {
                alert('Gagal memperbarui status: ' + (res.message || 'Error tidak diketahui'));
            }
        })
        .catch(() => {
            alert('Terjadi kesalahan jaringan.');
        })
        .finally(() => {
            button.innerHTML = originalButtonText;
            button.disabled = false;
        });
    });
});
</script>

</body>
</html>
