<?php
include 'config.php';

$data = json_decode(file_get_contents('php://input'), true);
$cart = $data['cart'] ?? [];
$table = $data['table_number'] ?? '';
$name = $data['customer_name'] ?? '';
$phone = $data['customer_phone'] ?? '';
$payment_option = $data['payment_option'] ?? 'cash';
$note = $data['note'] ?? '';

// Selalu set header ke JSON
header('Content-Type: application/json');

if (!$cart || !$table) {
    echo json_encode(['success' => false, 'message' => 'Data tidak lengkap']);
    exit;
}

$conn->begin_transaction();
try {
    $stmt = $conn->prepare("INSERT INTO orders (table_number, customer_name, customer_phone, payment_option, note) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param('sssss', $table, $name, $phone, $payment_option, $note);
    $stmt->execute();
    $order_id = $stmt->insert_id; // Ini adalah ID pesanan yang baru

    $stmt2 = $conn->prepare("INSERT INTO order_items (order_id, menu_id, quantity) VALUES (?, ?, ?)");
    foreach ($cart as $menu_id => $qty) {
        $stmt2->bind_param('iii', $order_id, $menu_id, $qty);
        $stmt2->execute();
    }
    $conn->commit();
    
    echo json_encode(['success' => true, 'order_id' => $order_id]); // Kirim order_id kembali

} catch (Exception $e) {
    $conn->rollback();
    
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>