let cart = JSON.parse(localStorage.getItem('cart')) || {};

document.querySelectorAll('.add-to-cart').forEach(btn => {
  btn.addEventListener('click', function() {
    const id = this.dataset.id;
    cart[id] = (cart[id] || 0) + 1;
    localStorage.setItem('cart', JSON.stringify(cart));
    alert('Ditambahkan ke keranjang!');
  });
});

document.getElementById('checkoutBtn').onclick = function() {
  if (Object.keys(cart).length === 0) {
    alert('Keranjang masih kosong!');
    return;
  }
  // Simulasi checkout: kirim ke API
  fetch('api/checkout.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({cart: cart, table_number: prompt('Nomor Meja?')})
  })
  .then(r => r.json())
  .then(res => {
    if(res.success) {
      alert('Pesanan berhasil, silakan tunggu!');
      localStorage.removeItem('cart');
      cart = {};
    } else {
      alert('Gagal: ' + res.message);
    }
  });
};
