<?php
session_start();
if (!isset($_SESSION['admin'])) header('Location: login.php');
include '../api/config.php';

$start_date = $_GET['start_date'] ?? date('Y-m-d');
$end_date = $_GET['end_date'] ?? date('Y-m-d');

$stmt = $conn->prepare("
    SELECT o.id, o.table_number, o.order_time, o.note, o.payment_option,
           GROUP_CONCAT(CONCAT(m.name, ' x', oi.quantity) SEPARATOR ', ') AS items, 
           SUM(oi.quantity * m.price) AS total
    FROM orders o
    JOIN order_items oi ON o.id = oi.order_id
    JOIN menu m ON oi.menu_id = m.id
    WHERE o.status = 'done' AND DATE(o.order_time) BETWEEN ? AND ?
    GROUP BY o.id
    ORDER BY o.order_time DESC
");
$stmt->bind_param('ss', $start_date, $end_date);
$stmt->execute();
$res = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Laporan Penjualan | LowFeeCoffee</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
<style>
    body {
        background-color: #f8f1e4;
        color: #4e342e;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    .main-header {
        background-color: #8d6e63;
        color: white;
    }

    .text-coffee {
        color: white;
    }

    .btn-primary {
        background-color: #8d6e63;
        border-color: #8d6e63;
        color: white;
    }

    .btn-primary:hover {
        background-color: #6d4c41;
        border-color: #6d4c41;
    }

    .btn-success {
        background-color: #a1887f;
        border-color: #a1887f;
        color: white;
    }

    .btn-success:hover {
        background-color: #8d6e63;
        border-color: #8d6e63;
        color: white;
    }

    .btn-secondary {
        background-color: #bcaaa4;
        border-color: #bcaaa4;
        color: #4e342e;
    }

    .btn-secondary:hover {
        background-color: #a1887f;
        border-color: #a1887f;
        color: white;
    }

    .table {
        border-collapse: separate;
        border-spacing: 0 0.5rem;
        color: #4e342e;
    }

    .table thead {
        background-color: #d7ccc8;
        color: #3e2723;
        font-weight: 600;
    }

    .table thead th {
        border: none;
        padding: 12px;
        font-size: 0.95rem;
    }

    .table tbody tr {
        background-color: #fffaf5;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        transition: background-color 0.2s ease;
    }

    .table tbody tr:hover {
        background-color: #f3e5f5;
    }

    .table tbody td {
        padding: 14px;
        vertical-align: middle;
        border-top: 1px solid #e0cfc2;
        font-size: 0.95rem;
    }

    .table tfoot {
        background-color: #efebe9;
        font-weight: bold;
        color: #3e2723;
    }

    h2, h1 {
        font-weight: bold;
    }

    input.form-control {
        border-radius: 8px;
    }

    label.form-label {
        font-weight: 500;
    }

    @media (max-width: 576px) {
        .main-header .container {
            flex-direction: column;
            align-items: start;
        }

        .main-header h1 {
            margin-bottom: 10px;
        }
    }
</style>

</head>
<body>

<!-- Header -->
<header class="main-header shadow-sm py-3 mb-4">
    <div class="container d-flex justify-content-between align-items-center">
        <h1 class="fs-4 m-0 fw-bold text-coffee">Laporan Penjualan</h1>
        <a href="logout.php" class="btn btn-sm btn-outline-light"><i class="bi bi-box-arrow-right"></i> Logout</a>
    </div>
</header>

<!-- Konten -->
<div class="container mb-5">
    <form class="row g-2 mb-4" method="get">
        <div class="col-auto">
            <label class="form-label">Dari:</label>
            <input type="date" name="start_date" value="<?= htmlspecialchars($start_date) ?>" class="form-control" required>
        </div>
        <div class="col-auto">
            <label class="form-label">Sampai:</label>
            <input type="date" name="end_date" value="<?= htmlspecialchars($end_date) ?>" class="form-control" required>
        </div>
        <div class="col-auto align-self-end">
            <button class="btn btn-primary"><i class="bi bi-search"></i> Tampilkan</button>
            <a href="download-excel.php?start_date=<?= $start_date ?>&end_date=<?= $end_date ?>" class="btn btn-success"><i class="bi bi-download"></i> Download Excel</a>
        </div>
    </form>

    <div class="table-responsive shadow-sm rounded bg-white p-3">
        <table class="table table-bordered table-striped align-middle">
            <thead>
                <tr>
                    <th>ID Pesanan</th>
                    <th>Meja</th>
                    <th>Waktu</th>
                    <th>Menu</th>
                    <th>Total</th>
                    <th>Catatan</th>
                    <th>Opsi Pembayaran</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $grand_total = 0;
                while ($row = $res->fetch_assoc()):
                    $grand_total += $row['total'];
                ?>
                <tr>
                    <td><?= $row['id'] ?></td>
                    <td><?= htmlspecialchars($row['table_number']) ?></td>
                    <td><?= $row['order_time'] ?></td>
                    <td><?= htmlspecialchars($row['items']) ?></td>
                    <td>Rp<?= number_format($row['total'],0,',','.') ?></td>
                    <td><?= nl2br(htmlspecialchars($row['note'])) ?></td>
                    <td><?= htmlspecialchars(ucfirst($row['payment_option'])) ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="4" class="text-end">Total Pendapatan</td>
                    <td colspan="3">Rp<?= number_format($grand_total,0,',','.') ?></td>
                </tr>
            </tfoot>
        </table>
    </div>

    <a href="dashboard.php" class="btn btn-secondary mt-4"><i class="bi bi-arrow-left"></i> Kembali ke Dashboard</a>
</div>

</body>
</html>
