<?php
session_start();
if (!isset($_SESSION['admin'])) header('Location: login.php');
include '../api/config.php';

$total_orders = $conn->query("SELECT COUNT(*) FROM orders")->fetch_row()[0];
$pending_orders = $conn->query("SELECT COUNT(*) FROM orders WHERE status='pending'")->fetch_row()[0];
$done_orders = $conn->query("SELECT COUNT(*) FROM orders WHERE status='done'")->fetch_row()[0];
$total_menu = $conn->query("SELECT COUNT(*) FROM menu")->fetch_row()[0];
$recent_orders = $conn->query("SELECT id, table_number, order_time FROM orders WHERE status='pending' ORDER BY order_time DESC LIMIT 5");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin | LowFeeCoffee</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

    <style>
    :root {
        --primary-color: #6f4e37;
        --primary-light: #f2e7dc;
        --accent-color: #eaddcf;
        --bg-light: #f9f6f2;
        --font-family-sans-serif: 'Poppins', sans-serif;
        --box-shadow: 0 5px 15px rgba(0,0,0,0.06);
        --transition: all 0.3s ease;
    }

    body {
        background-color: var(--bg-light);
        font-family: var(--font-family-sans-serif);
        color: #4e342e;
        line-height: 1.6;
        margin: 0;
        padding: 1.5rem;
    }

    .d-flex {
        gap: 2rem;
    }

    header {
        background-color: #fff;
        padding: 1.5rem 2rem;
        box-shadow: var(--box-shadow);
        border-radius: 0 0 1.5rem 1.5rem;
        margin-bottom: 2rem;
    }

    .sidebar {
        width: 260px;
        min-height: 100vh;
        background-color: var(--primary-light);
        box-shadow: 2px 0 8px rgba(0,0,0,0.03);
        border-radius: 1.5rem;
        padding: 1.5rem 1rem;
    }

    .sidebar-header {
        padding: 1.5rem;
        border-bottom: 1px solid #d7ccc8;
        text-align: center;
    }

    .sidebar-header a {
        font-weight: 700;
        color: var(--primary-color);
        text-decoration: none;
        font-size: 1.3rem;
    }

    .sidebar .nav-link {
        padding: 12px 24px;
        color: #5d4037;
        font-weight: 500;
        display: flex;
        align-items: center;
        border-left: 4px solid transparent;
        transition: var(--transition);
        border-radius: 0.75rem;
        margin: 0.25rem 0;
    }

    .sidebar .nav-link i {
        margin-right: 1rem;
        font-size: 1.2rem;
        width: 20px;
        text-align: center;
    }

    .sidebar .nav-link:hover,
    .sidebar .nav-link.active {
        background-color: var(--accent-color);
        color: var(--primary-color);
        border-left-color: var(--primary-color);
        font-weight: 600;
    }

    .main-content {
        flex-grow: 1;
        padding: 2rem;
        background-color: #fffefb;
        border-radius: 1.5rem;
        box-shadow: var(--box-shadow);
        margin-bottom: 2rem;
    }

    .card {
        border-radius: 1rem;
        border: none;
        box-shadow: var(--box-shadow);
    }

    .card-header, .card-footer {
        background-color: var(--primary-light);
        border: none;
        color: var(--primary-color);
    }

    .table thead {
        background-color: var(--accent-color);
        color: var(--primary-color);
    }

    .btn-outline-primary {
        border-color: var(--primary-color);
        color: var(--primary-color);
        transition: var(--transition);
    }

    .btn-outline-primary:hover {
        background-color: var(--primary-color);
        color: #fff;
    }

    /* Circle Stats */
    .circle {
        width: 120px;
        height: 120px;
        border-radius: 50%;
        background-color: var(--primary-color);
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2.7rem;
        font-weight: 600;
        box-shadow: 0 8px 20px rgba(0,0,0,0.1);
        margin-bottom: 0.75rem;
    }

    .data-item {
        display: flex;
        flex-direction: column;
        align-items: center;
        font-size: 1.1rem;
    }

    .data-container {
        display: flex;
        justify-content: center;
        flex-wrap: wrap;
        gap: 2.5rem;
        padding: 1.5rem 0;
    }

    .data-column {
        width: 220px;
        text-align: center;
    }
    </style>
</head>
<body>
<div class="d-flex">
    <div class="sidebar d-flex flex-column flex-shrink-0">
        <div class="sidebar-header">
            <a href="dashboard.php"><i class="bi bi-cup-hot-fill me-2"></i>Admin Panel</a>
        </div>
        <ul class="nav nav-pills flex-column mb-auto mt-3">
            <li class="nav-item"><a class="nav-link active" href="dashboard.php"><i class="bi-grid-fill"></i>Dashboard</a></li>
            <li class="nav-item"><a class="nav-link" href="menu-management.php"><i class="bi-cup-straw"></i>Manajemen Menu</a></li>
            <li class="nav-item"><a class="nav-link" href="orders.php"><i class="bi-receipt"></i>Daftar Pesanan</a></li>
            <li class="nav-item"><a class="nav-link" href="tables.php"><i class="bi-table"></i>Manajemen Meja</a></li>
            <li class="nav-item"><a class="nav-link" href="daily-report.php"><i class="bi-calendar-check"></i>Laporan Harian</a></li>
            <li class="nav-item"><a class="nav-link" href="reports.php"><i class="bi-file-earmark-bar-graph"></i>Laporan Penjualan</a></li>
            <li class="nav-item mt-4 border-top pt-3"><a class="nav-link" href="logout.php"><i class="bi-box-arrow-left"></i>Logout</a></li>
        </ul>
    </div>

    <main class="main-content">
        <header>
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="fw-bold">Dashboard</h2>
                    <p class="text-muted">Selamat datang, <strong><?= htmlspecialchars($_SESSION['admin']) ?></strong>!</p>
                </div>
            </div>
        </header>

        <div class="data-container">
            <div class="data-column">
                <div class="data-item">
                    <div class="circle"><?= $total_orders ?></div>
                    <span>Total Pesanan</span>
                </div>
            </div>
            <div class="data-column">
                <div class="data-item">
                    <div class="circle"><?= $pending_orders ?></div>
                    <span>Pesanan Pending</span>
                </div>
            </div>
            <div class="data-column">
                <div class="data-item">
                    <div class="circle"><?= $done_orders ?></div>
                    <span>Pesanan Selesai</span>
                </div>
            </div>
            <div class="data-column">
                <div class="data-item">
                    <div class="circle"><?= $total_menu ?></div>
                    <span>Total Item Menu</span>
                </div>
            </div>
        </div>

        <div class="card mt-4">
            <div class="card-header">
                <h5 class="fw-bold mb-0">Pesanan Pending Terbaru</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead>
                            <tr>
                                <th>ID Pesanan</th>
                                <th>Nomor Meja</th>
                                <th>Waktu Pesan</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($recent_orders->num_rows > 0): ?>
                                <?php while($row = $recent_orders->fetch_assoc()): ?>
                                <tr>
                                    <td><strong>#<?= $row['id'] ?></strong></td>
                                    <td><?= htmlspecialchars($row['table_number']) ?></td>
                                    <td><?= date('d M Y, H:i', strtotime($row['order_time'])) ?></td>
                                    <td><a href="orders.php" class="btn btn-sm btn-outline-primary">Lihat Detail</a></td>
                                </tr>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-4">Tidak ada pesanan pending saat ini.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer text-center">
                <a href="orders.php">Lihat Semua Pesanan &rarr;</a>
            </div>
        </div>
    </main>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
