<?php
session_start();
if (!isset($_SESSION['admin'])) {
    exit('Unauthorized access');
}

include '../api/config.php';

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($id <= 0) {
    exit('ID pesanan tidak valid');
}

// Ambil data pesanan
$stmt = $conn->prepare("SELECT * FROM orders WHERE id = ?");
$stmt->bind_param('i', $id);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();

if (!$order) {
    exit('Pesanan tidak ditemukan');
}

// Ambil detail item pesanan
$items = $conn->query("
    SELECT m.name, oi.quantity, m.price
    FROM order_items oi
    JOIN menu m ON oi.menu_id = m.id
    WHERE oi.order_id = $id
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <title>Struk Pesanan #<?= htmlspecialchars($order['id']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        @media print {
            .no-print { display: none; }
            body { font-family: monospace; font-size: 12pt; }
        }
        body {
            max-width: 400px;
            margin: 20px auto;
            font-family: monospace;
            font-size: 14px;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 8px;
        }
        h4, h5 {
            text-align: center;
            margin-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        th, td {
            padding: 6px 4px;
            border-bottom: 1px solid #ddd;
        }
        th {
            text-align: left;
        }
        .text-right {
            text-align: right;
        }
        .footer {
            text-align: center;
            margin-top: 15px;
            font-style: italic;
        }
    </style>
</head>
<body>
    <h4>LowFeeCoffee</h4>
    <h5>Struk Pesanan #<?= htmlspecialchars($order['id']) ?></h5>
    <div><strong>Meja:</strong> <?= htmlspecialchars($order['table_number']) ?></div>
    <div><strong>Waktu:</strong> <?= htmlspecialchars($order['order_time']) ?></div>
    <hr />
    <table>
        <thead>
            <tr>
                <th>Menu</th>
                <th>Qty</th>
                <th class="text-right">Subtotal</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $total = 0;
            while ($item = $items->fetch_assoc()):
                $subtotal = $item['price'] * $item['quantity'];
                $total += $subtotal;
            ?>
            <tr>
                <td><?= htmlspecialchars($item['name']) ?></td>
                <td><?= $item['quantity'] ?></td>
                <td class="text-right">Rp <?= number_format($subtotal, 0, ',', '.') ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="2" class="text-right">Total</th>
                <th class="text-right">Rp <?= number_format($total, 0, ',', '.') ?></th>
            </tr>
        </tfoot>
    </table>

    <div><strong>Opsi Pembayaran:</strong> <?= htmlspecialchars(ucfirst($order['payment_option'])) ?></div>

    <?php if (!empty($order['note'])): ?>
    <div style="margin-top:10px;">
        <strong>Catatan:</strong><br />
        <?= nl2br(htmlspecialchars($order['note'])) ?>
    </div>
    <?php endif; ?>

    <hr />
    <div class="footer">
        Terima kasih telah memesan di LowFeeCoffee!<br />
        Selamat menikmati kopi Anda ☕
    </div>

    <div class="no-print text-center mt-3">
        <button onclick="window.print()" class="btn btn-primary btn-sm">Cetak Struk</button>
        <a href="orders.php" class="btn btn-secondary btn-sm">Kembali ke Pesanan</a>
    </div>
</body>
</html>
