<?php
session_start();
if (!isset($_SESSION['admin'])) header('Location: login.php');
include '../api/config.php';

if ($_SERVER['REQUEST_METHOD']=='POST') {
    if ($_POST['action']=='add') {
        $num = $_POST['table_number'];
        $qr = 'QR-'.$num;
        $stmt = $conn->prepare("INSERT INTO tables (table_number, qr_code) VALUES (?,?)");
        $stmt->bind_param('ss', $num, $qr);
        $stmt->execute();
        header('Location: tables.php');
        exit;
    } elseif ($_POST['action']=='delete') {
        $id = $_POST['id'];
        $conn->query("DELETE FROM tables WHERE id=$id");
        header('Location: tables.php');
        exit;
    }
}
$tables = $conn->query("SELECT * FROM tables");
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Kelola Meja & QR | LowFeeCoffee</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<style>
    body {
        background-color: #f8f1e4;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: #4e342e;
    }

    .main-header {
        background-color: #8d6e63;
        color: white;
    }

    .text-coffee {
        color: white;
    }

    .btn-success {
        background-color: #6d4c41;
        border-color: #6d4c41;
        color: white;
    }

    .btn-success:hover {
        background-color: #5d4037;
        border-color: #5d4037;
    }

    .btn-danger {
        background-color: #a1887f;
        border-color: #a1887f;
        color: white;
    }

    .btn-danger:hover {
        background-color: #8d6e63;
        border-color: #8d6e63;
        color: white;
    }

    .btn-secondary {
        background-color: #bcaaa4;
        border-color: #bcaaa4;
        color: #4e342e;
    }

    .btn-secondary:hover {
        background-color: #a1887f;
        border-color: #a1887f;
        color: white;
    }

    .table {
        border-collapse: separate;
        border-spacing: 0 0.5rem;
        color: #4e342e;
    }

    .table thead {
        background-color: #bcaaa4;
        color: #3e2723;
        font-weight: 600;
    }

    .table thead th {
        border: none;
        padding: 12px;
        font-size: 0.95rem;
    }

    .table tbody tr {
        background-color: #fffaf5;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        transition: background-color 0.2s ease;
    }

    .table tbody tr:hover {
        background-color: #f3e5f5;
    }

    .table tbody td {
        padding: 14px;
        vertical-align: middle;
        border-top: 1px solid #e0cfc2;
        font-size: 0.95rem;
    }

    .table-striped > tbody > tr:nth-of-type(odd) {
        background-color: #f3ede8;
    }

    .nav-links a {
        color: white;
        margin-left: 15px;
        text-decoration: none;
        font-weight: 500;
    }

    .nav-links a:hover {
        text-decoration: underline;
    }

    @media (max-width: 576px) {
        .nav-links {
            flex-direction: column;
            align-items: start;
            margin-top: 10px;
        }

        .nav-links a {
            margin-left: 0;
            margin-bottom: 5px;
        }
    }

    .card {
        border-radius: 12px;
        background-color: #fffaf5;
        padding: 20px;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
    }

    input.form-control {
        border-radius: 8px;
    }
</style>

</head>
<body>

<!-- Header -->
<header class="main-header shadow-sm py-3 mb-4">
    <div class="container d-flex flex-column flex-sm-row justify-content-between align-items-sm-center">
        <h1 class="fs-4 m-0 fw-bold text-coffee">Kelola Meja & QR</h1>
        <div class="nav-links d-flex align-items-center">
            <a href="menu.php"><i class="bi bi-cup-hot"></i> Kelola Menu</a>
            <a href="laporan.php"><i class="bi bi-bar-chart"></i> Laporan</a>
            <a href="logout.php" class="btn btn-sm btn-outline-light ms-3">
                <i class="bi bi-box-arrow-right"></i> Logout
            </a>
        </div>
    </div>
</header>

<!-- Konten -->
<div class="container mb-5">
    <div class="shadow-sm rounded bg-white p-4">
        <form method="post" class="row g-2 mb-4">
            <input type="hidden" name="action" value="add">
            <div class="col-md-4">
                <input type="text" name="table_number" class="form-control" placeholder="Nomor Meja" required>
            </div>
            <div class="col-md-2">
                <button class="btn btn-success w-100"><i class="bi bi-plus-circle"></i> Tambah</button>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-bordered table-striped align-middle">
                <thead>
                    <tr>
                        <th>Nomor Meja</th>
                        <th>QR Code</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $tables->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['table_number']) ?></td>
                        <td><?= htmlspecialchars($row['qr_code']) ?></td>
                        <td>
                            <form method="post" style="display:inline">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                <button class="btn btn-danger btn-sm" onclick="return confirm('Hapus meja ini?')">
                                    <i class="bi bi-trash"></i> Hapus
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <a href="dashboard.php" class="btn btn-secondary mt-4">
            <i class="bi bi-arrow-left"></i> Kembali ke Dashboard
        </a>
    </div>
</div>

</body>
</html>
