<?php
session_start();
if (!isset($_SESSION['admin'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

include 'config.php';
header('Content-Type: application/json');

// Ambil semua data dari POST
$id = $_POST['id'];
$name = $_POST['name'];
$description = $_POST['description'];
$category = $_POST['category'];
$price = $_POST['price'];
$avaiable = $_POST['avaiable']; // Add availability field

// Query dasar untuk update teks dan availability
$sql = "UPDATE menu SET name=?, description=?, category=?, price=?, avaiable=? WHERE id=?";
$params = [$name, $description, $category, $price, $avaiable, $id];
$types = 'sssisi';

// Cek jika ada gambar baru yang di-upload
if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
    // Hapus gambar lama terlebih dahulu
    $stmt = $conn->prepare("SELECT image FROM menu WHERE id=?");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $res = $stmt->get_result();
    if($res->num_rows > 0) {
        $img_to_delete = $res->fetch_assoc()['image'];
        if ($img_to_delete && file_exists('../assets/uploads/'.$img_to_delete)) {
            unlink('../assets/uploads/'.$img_to_delete);
        }
    }
    
    // Upload gambar baru
    $target_dir = "../assets/uploads/";
    $img_new = uniqid() . basename($_FILES['image']['name']);
    move_uploaded_file($_FILES['image']['tmp_name'], $target_dir . $img_new);

    // Update query untuk menyertakan gambar baru
    $sql = "UPDATE menu SET name=?, description=?, category=?, price=?, avaiable=?, image=? WHERE id=?";
    $params = [$name, $description, $category, $price, $avaiable, $img_new, $id];
    $types = 'sssisii'; // Update types to include image and id
}

// Eksekusi query update
$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);

if ($stmt->execute()) {
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => $stmt->error]);
}
