<?php
include 'api/config.php';

// Validasi ID Pesanan dari URL
$order_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($order_id <= 0) {
    die("ID Pesanan tidak valid.");
}

// Ambil data utama pesanan
$stmt = $conn->prepare("SELECT * FROM orders WHERE id = ?");
$stmt->bind_param('i', $order_id);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$order) {
    die("Pesanan tidak ditemukan.");
}

// Ambil item-item dalam pesanan
$items_stmt = $conn->prepare("
    SELECT m.name, m.price, oi.quantity 
    FROM order_items oi
    JOIN menu m ON oi.menu_id = m.id
    WHERE oi.order_id = ?
");
$items_stmt->bind_param('i', $order_id);
$items_stmt->execute();
$items = $items_stmt->get_result();
$items_stmt->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice Pesanan #<?= htmlspecialchars($order['id']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&family=Source+Code+Pro:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body {
            background-color: #f4f1ec;
            font-family: 'Poppins', sans-serif;
        }
        .invoice-box {
            max-width: 480px;
            margin: 40px auto;
            padding: 30px 25px;
            border-radius: 16px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            background-color: #ffffff;
            font-size: 14px;
            color: #3e2f1c;
        }
        .invoice-header {
            text-align: center;
            margin-bottom: 20px;
        }
        .invoice-header h2 {
            font-weight: 600;
            font-size: 24px;
            color: #5a3825;
        }
        .invoice-header .address {
            font-size: 13px;
            color: #6e4b32;
            margin-top: -5px;
        }
        .invoice-details table {
            width: 100%;
            text-align: left;
            border-collapse: collapse;
        }
        .invoice-details table td {
            padding: 8px 5px;
            vertical-align: top;
        }
        .invoice-details table tr.heading td {
            background: #e0cfc2;
            border-bottom: 1px solid #c8b4a4;
            font-weight: 600;
            color: #4d3829;
        }
        .invoice-details table tr.item td {
            border-bottom: 1px solid #f0e6dc;
        }
        .invoice-details table tr.total td:last-child {
            font-weight: 700;
            color: #5a3825;
        }
        .text-end {
            text-align: right;
        }
        .actions {
            margin-top: 30px;
            text-align: center;
        }
        .footer-note {
            margin-top: 25px;
            font-size: 12px;
            text-align: center;
            color: #5a3825;
            font-style: italic;
        }
        .btn {
            padding: 8px 16px;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 500;
            margin: 5px;
        }
        .btn-primary {
            background-color: #6f4e37;
            border: none;
        }
        .btn-primary:hover {
            background-color: #5a3e2d;
        }
        .btn-secondary {
            background-color: #d4c0aa;
            color: #3e2f1c;
            border: none;
        }
        .btn-secondary:hover {
            background-color: #bda88f;
        }
        hr {
            border-top: 1px solid #ddd;
            margin: 20px 0;
        }
        .thankyou-text {
            margin-top: 20px;
            text-align: center;
            font-size: 13px;
            color: #5a3825;
            font-style: italic;
        }
        @media print {
            body {
                background-color: #fff;
            }
            .invoice-box {
                box-shadow: none;
                border: none;
                margin: 0;
                padding: 0;
                max-width: 100%;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>

    <div class="invoice-box">
        <div class="invoice-header">
            <h2>Low.Fee Coffee</h2>
            <div class="address">Jl. Vila Santika Blok RK No. 9, Depok<br>Telp: (+62)-852-8382-1948</div>
        </div>

        <!-- Info Pesanan dan Waktu -->
        <div class="d-flex justify-content-between mb-2">
            <div><strong>No. Pesanan:</strong> #<?= htmlspecialchars($order['id']) ?></div>
            <div><strong>Waktu:</strong> <?= date('d M Y, H:i', strtotime($order['order_time'])) ?></div>
        </div>
        <div class="d-flex justify-content-between mb-3">
            <div><strong>No. Meja:</strong> <?= htmlspecialchars($order['table_number']) ?></div>
            <div><strong>Pembayaran:</strong> <?= ucfirst(htmlspecialchars($order['payment_option'])) ?></div>
        </div>

        <hr>

        <!-- Daftar Menu -->
        <table class="invoice-details">
            <tr class="heading">
                <td>Menu</td>
                <td>Qty</td>
                <td class="text-end">Subtotal</td>
            </tr>
            <?php 
            $grand_total = 0;
            while($item = $items->fetch_assoc()):
                $subtotal = $item['price'] * $item['quantity'];
                $grand_total += $subtotal;
            ?>
            <tr class="item">
                <td><?= htmlspecialchars($item['name']) ?></td>
                <td><?= $item['quantity'] ?></td>
                <td class="text-end">Rp <?= number_format($subtotal, 0, ',', '.') ?></td>
            </tr>
            <?php endwhile; ?>
            <tr class="total">
                <td colspan="2" class="text-end"><strong>Total</strong></td>
                <td class="text-end"><strong>Rp <?= number_format($grand_total, 0, ',', '.') ?></strong></td>
            </tr>
        </table>

        <?php if (!empty($order['note'])): ?>
            <hr>
            <strong>Catatan:</strong><br>
            <?= nl2br(htmlspecialchars($order['note'])) ?>
        <?php endif; ?>

        <div class="footer-note">
            Barang yang sudah dibeli tidak dapat dikembalikan.<br>
            Ini adalah bukti pesanan Anda, simpan struk ini sebagai bukti transaksi.
        </div>

        <div class="thankyou-text">
            Terima kasih telah berkunjung ke Low.Fee Coffee!
        </div>

        <div class="actions no-print">
            <button onclick="window.print()" class="btn btn-primary"><i class="bi bi-printer"></i> Cetak Struk</button>
            <a href="menu.php" class="btn btn-secondary"><i class="bi bi-arrow-left"></i> Kembali ke Menu</a>
        </div>
    </div>

</body>
</html>
